/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.display;

import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.block.display.DisplayBehaviour;
import com.simibubi.create.content.logistics.block.display.source.DeathCounterDisplaySource;
import com.simibubi.create.content.logistics.block.display.source.DisplaySource;
import com.simibubi.create.content.logistics.block.display.source.EnchantPowerDisplaySource;
import com.simibubi.create.content.logistics.block.display.source.RedstonePowerDisplaySource;
import com.simibubi.create.content.logistics.block.display.source.ScoreboardDisplaySource;
import com.simibubi.create.content.logistics.block.display.target.DisplayTarget;
import com.simibubi.create.content.logistics.block.display.target.LecternDisplayTarget;
import com.simibubi.create.content.logistics.block.display.target.SignDisplayTarget;
import com.simibubi.create.foundation.utility.CreateRegistry;
import com.simibubi.create.foundation.utility.RegisteredObjects;
import com.tterrag.registrate.util.nullness.NonNullConsumer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;

public class AllDisplayBehaviours {
    public static final Map<class_2960, DisplayBehaviour> GATHERER_BEHAVIOURS = new HashMap<class_2960, DisplayBehaviour>();
    private static final CreateRegistry<class_2248, List<DisplaySource>> SOURCES_BY_BLOCK = new CreateRegistry(class_2378.field_11146);
    private static final CreateRegistry<class_2591<?>, List<DisplaySource>> SOURCES_BY_TILE = new CreateRegistry(class_2378.field_11137);
    private static final CreateRegistry<class_2248, DisplayTarget> TARGETS_BY_BLOCK = new CreateRegistry(class_2378.field_11146);
    private static final CreateRegistry<class_2591<?>, DisplayTarget> TARGETS_BY_TILE = new CreateRegistry(class_2378.field_11137);

    public static DisplayBehaviour register(class_2960 id, DisplayBehaviour behaviour) {
        behaviour.id = id;
        GATHERER_BEHAVIOURS.put(id, behaviour);
        return behaviour;
    }

    public static void assignBlock(DisplayBehaviour behaviour, class_2960 block) {
        if (behaviour instanceof DisplaySource) {
            DisplaySource source = (DisplaySource)behaviour;
            List<DisplaySource> sources = SOURCES_BY_BLOCK.get((class_2248)block);
            if (sources == null) {
                sources = new ArrayList<DisplaySource>();
                SOURCES_BY_BLOCK.register((class_2248)block, sources);
            }
            sources.add(source);
        }
        if (behaviour instanceof DisplayTarget) {
            DisplayTarget target = (DisplayTarget)behaviour;
            TARGETS_BY_BLOCK.register((class_2248)block, target);
        }
    }

    public static void assignTile(DisplayBehaviour behaviour, class_2960 teType) {
        if (behaviour instanceof DisplaySource) {
            DisplaySource source = (DisplaySource)behaviour;
            List<DisplaySource> sources = SOURCES_BY_TILE.get((class_2591<?>)teType);
            if (sources == null) {
                sources = new ArrayList<DisplaySource>();
                SOURCES_BY_TILE.register((class_2591<?>)teType, sources);
            }
            sources.add(source);
        }
        if (behaviour instanceof DisplayTarget) {
            DisplayTarget target = (DisplayTarget)behaviour;
            TARGETS_BY_TILE.register((class_2591<?>)teType, target);
        }
    }

    public static void assignBlock(DisplayBehaviour behaviour, class_2248 block) {
        if (behaviour instanceof DisplaySource) {
            DisplaySource source = (DisplaySource)behaviour;
            List<DisplaySource> sources = SOURCES_BY_BLOCK.get(block);
            if (sources == null) {
                sources = new ArrayList<DisplaySource>();
                SOURCES_BY_BLOCK.register(block, sources);
            }
            sources.add(source);
        }
        if (behaviour instanceof DisplayTarget) {
            DisplayTarget target = (DisplayTarget)behaviour;
            TARGETS_BY_BLOCK.register(block, target);
        }
    }

    public static void assignTile(DisplayBehaviour behaviour, class_2591<?> teType) {
        if (behaviour instanceof DisplaySource) {
            DisplaySource source = (DisplaySource)behaviour;
            List<DisplaySource> sources = SOURCES_BY_TILE.get(teType);
            if (sources == null) {
                sources = new ArrayList<DisplaySource>();
                SOURCES_BY_TILE.register(teType, sources);
            }
            sources.add(source);
        }
        if (behaviour instanceof DisplayTarget) {
            DisplayTarget target = (DisplayTarget)behaviour;
            TARGETS_BY_TILE.register(teType, target);
        }
    }

    public static <B extends class_2248> NonNullConsumer<? super B> assignDataBehaviour(DisplayBehaviour behaviour, String ... suffix) {
        return b -> {
            Object idSuffix;
            class_2960 registryName = RegisteredObjects.getKeyOrThrow(b);
            Object object = idSuffix = behaviour instanceof DisplaySource ? "_source" : "_target";
            if (suffix.length > 0) {
                idSuffix = (String)idSuffix + "_" + suffix[0];
            }
            AllDisplayBehaviours.assignBlock(AllDisplayBehaviours.register(new class_2960(registryName.method_12836(), registryName.method_12832() + (String)idSuffix), behaviour), registryName);
        };
    }

    public static <B extends class_2591<?>> NonNullConsumer<? super B> assignDataBehaviourTE(DisplayBehaviour behaviour, String ... suffix) {
        return b -> {
            Object idSuffix;
            class_2960 registryName = RegisteredObjects.getKeyOrThrow(b);
            Object object = idSuffix = behaviour instanceof DisplaySource ? "_source" : "_target";
            if (suffix.length > 0) {
                idSuffix = (String)idSuffix + "_" + suffix[0];
            }
            AllDisplayBehaviours.assignTile(AllDisplayBehaviours.register(new class_2960(registryName.method_12836(), registryName.method_12832() + (String)idSuffix), behaviour), registryName);
        };
    }

    @Nullable
    public static DisplaySource getSource(class_2960 resourceLocation) {
        DisplayBehaviour available = GATHERER_BEHAVIOURS.getOrDefault(resourceLocation, null);
        if (available instanceof DisplaySource) {
            DisplaySource source = (DisplaySource)available;
            return source;
        }
        return null;
    }

    @Nullable
    public static DisplayTarget getTarget(class_2960 resourceLocation) {
        DisplayBehaviour available = GATHERER_BEHAVIOURS.getOrDefault(resourceLocation, null);
        if (available instanceof DisplayTarget) {
            DisplayTarget target = (DisplayTarget)available;
            return target;
        }
        return null;
    }

    public static List<DisplaySource> sourcesOf(class_2248 block) {
        List<DisplaySource> sources = SOURCES_BY_BLOCK.get(block);
        if (sources == null) {
            return Collections.emptyList();
        }
        return sources;
    }

    public static List<DisplaySource> sourcesOf(class_2680 state) {
        return AllDisplayBehaviours.sourcesOf(state.method_26204());
    }

    public static List<DisplaySource> sourcesOf(class_2591<?> tileEntityType) {
        List<DisplaySource> sources = SOURCES_BY_TILE.get(tileEntityType);
        if (sources == null) {
            return Collections.emptyList();
        }
        return sources;
    }

    public static List<DisplaySource> sourcesOf(class_2586 tileEntity) {
        return AllDisplayBehaviours.sourcesOf(tileEntity.method_11017());
    }

    @Nullable
    public static DisplayTarget targetOf(class_2248 block) {
        return TARGETS_BY_BLOCK.get(block);
    }

    @Nullable
    public static DisplayTarget targetOf(class_2680 state) {
        return AllDisplayBehaviours.targetOf(state.method_26204());
    }

    @Nullable
    public static DisplayTarget targetOf(class_2591<?> tileEntityType) {
        return TARGETS_BY_TILE.get(tileEntityType);
    }

    @Nullable
    public static DisplayTarget targetOf(class_2586 tileEntity) {
        return AllDisplayBehaviours.targetOf(tileEntity.method_11017());
    }

    public static List<DisplaySource> sourcesOf(class_1936 level, class_2338 pos) {
        List<Object> sourcesOfTE;
        class_2680 blockState = level.method_8320(pos);
        class_2586 blockEntity = level.method_8321(pos);
        List<DisplaySource> sourcesOfBlock = AllDisplayBehaviours.sourcesOf(blockState);
        List<Object> list = sourcesOfTE = blockEntity == null ? Collections.emptyList() : AllDisplayBehaviours.sourcesOf(blockEntity);
        if (sourcesOfTE.isEmpty()) {
            return sourcesOfBlock;
        }
        return sourcesOfTE;
    }

    @Nullable
    public static DisplayTarget targetOf(class_1936 level, class_2338 pos) {
        DisplayTarget targetOfTE;
        class_2680 blockState = level.method_8320(pos);
        class_2586 blockEntity = level.method_8321(pos);
        DisplayTarget targetOfBlock = AllDisplayBehaviours.targetOf(blockState);
        DisplayTarget displayTarget = targetOfTE = blockEntity == null ? null : AllDisplayBehaviours.targetOf(blockEntity);
        if (targetOfTE == null) {
            return targetOfBlock;
        }
        return targetOfTE;
    }

    public static void registerDefaults() {
        AllDisplayBehaviours.assignTile(AllDisplayBehaviours.register(Create.asResource("sign_display_target"), new SignDisplayTarget()), class_2591.field_11911);
        AllDisplayBehaviours.assignTile(AllDisplayBehaviours.register(Create.asResource("lectern_display_target"), new LecternDisplayTarget()), class_2591.field_16412);
        AllDisplayBehaviours.assignBlock(AllDisplayBehaviours.register(Create.asResource("death_count_display_source"), new DeathCounterDisplaySource()), class_2246.field_23152);
        AllDisplayBehaviours.assignTile(AllDisplayBehaviours.register(Create.asResource("scoreboard_display_source"), new ScoreboardDisplaySource()), class_2591.field_11904);
        AllDisplayBehaviours.assignTile(AllDisplayBehaviours.register(Create.asResource("enchant_power_display_source"), new EnchantPowerDisplaySource()), class_2591.field_11912);
        AllDisplayBehaviours.assignBlock(AllDisplayBehaviours.register(Create.asResource("redstone_power_display_source"), new RedstonePowerDisplaySource()), class_2246.field_22422);
    }
}

